/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.engine;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.HashMap;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.Engine;
import net.nooj4nlp.engine.Gram;
import net.nooj4nlp.engine.GramType;
import net.nooj4nlp.engine.Grammar;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.Regexp;
import net.nooj4nlp.engine.helper.ParameterCheck;

public class Regexps
implements Serializable {
    private static final String MAIN = "Main";
    private static final long serialVersionUID = -6677839946698256614L;
    public Grammar grammar;

    public Regexps(Language ilanguage, GramType gramType, Gram gram, Engine engine) {
        this.grammar = new Grammar(ilanguage, gramType, engine);
        this.grammar.grams = new HashMap();
        if (gramType != GramType.FLX) {
            this.grammar.grams.put(MAIN, gram);
        }
    }

    private static int getRule(String line, int ibuffer, StringBuilder rname, RefObject<String> expression) {
        ParameterCheck.mandatoryString("line", line);
        ParameterCheck.mandatory("rname", rname);
        ParameterCheck.mandatory("expression", expression);
        rname.delete(0, rname.length());
        expression.argvalue = null;
        int i = ibuffer;
        boolean skipped = true;
        while (skipped) {
            skipped = false;
            if (Character.isWhitespace(line.charAt(i))) {
                skipped = true;
                ++i;
                while (i < line.length() && Character.isWhitespace(line.charAt(i))) {
                    ++i;
                }
                if (i == line.length()) {
                    return -1;
                }
            }
            if (line.charAt(i) != '#') continue;
            skipped = true;
            ++i;
            while (i < line.length() && line.charAt(i) != '\n') {
                ++i;
            }
            if (i != line.length()) continue;
            return -1;
        }
        int j = 0;
        while (i + j < line.length() && line.charAt(i + j) != '=' && !Character.isWhitespace(line.charAt(i + j))) {
            ++j;
        }
        if (i + j == line.length()) {
            return -2;
        }
        rname.append(line.substring(i, i + j));
        int k = 0;
        while (i + j + k < line.length() && line.charAt(i + j + k) != '=' && Character.isWhitespace(line.charAt(i + j + k))) {
            ++k;
        }
        if (i + j + k == line.length() || line.charAt(i + j + k) != '=') {
            return -2;
        }
        int m = 1;
        while (i + j + k + m < line.length() && line.charAt(i + j + k + m) != ';') {
            if (line.charAt(i + j + k + m) == '\"') {
                ++m;
                while (line.charAt(i + j + k + m) != '\"') {
                    ++m;
                }
            }
            ++m;
        }
        if (i + j + k + m == line.length() || line.charAt(i + j + k + m) != ';') {
            return -2;
        }
        expression.argvalue = line.substring(i + j + k + 1, i + j + k + m);
        return i + j + k + m + 1;
    }

    private static String removeComments(String inputBuffer, RefObject<String> ilanguageName, RefObject<String> olanguageName, RefObject<GramType> gramType) {
        ParameterCheck.mandatoryString("inputBuffer", inputBuffer);
        ParameterCheck.mandatory("ilanguageName", ilanguageName);
        ParameterCheck.mandatory("olanguageName", olanguageName);
        ParameterCheck.mandatory("gramType", gramType);
        ilanguageName.argvalue = null;
        olanguageName.argvalue = null;
        gramType.argvalue = GramType.FLX;
        StringBuilder buffer = new StringBuilder();
        boolean begofline = true;
        for (int i = 0; i < inputBuffer.length(); ++i) {
            if (inputBuffer.charAt(i) == '\"') {
                buffer.append(inputBuffer.charAt(i));
                ++i;
                while (i < inputBuffer.length() && inputBuffer.charAt(i) != '\"') {
                    buffer.append(inputBuffer.charAt(i));
                    ++i;
                }
                buffer.append(inputBuffer.charAt(i));
                begofline = false;
                ++i;
            } else if (inputBuffer.charAt(i) == '\\') {
                ++i;
                begofline = false;
            } else if (inputBuffer.charAt(i) == '#' && begofline) {
                String pref;
                int j = 0;
                while (i + j < inputBuffer.length() && inputBuffer.charAt(i + j) != '\n') {
                    ++j;
                }
                begofline = true;
                String commentline = inputBuffer.substring(i, i + j);
                if (commentline.equals("# Syntactic grammar")) {
                    gramType.argvalue = GramType.SYNTAX;
                } else if (commentline.equals("# Morphological grammar")) {
                    gramType.argvalue = GramType.MORPHO;
                }
                if (commentline.length() > 15 && (pref = commentline.substring(0, 15)).equals("# Language is: ")) {
                    ilanguageName.argvalue = commentline.substring(15);
                }
                if (commentline.length() > 21 && (pref = commentline.substring(0, 21)).equals("# Input Language is: ")) {
                    ilanguageName.argvalue = commentline.substring(21);
                }
                if (commentline.length() > 22 && (pref = commentline.substring(0, 22)).equals("# Output Language is: ")) {
                    olanguageName.argvalue = commentline.substring(22);
                }
                i += j;
            }
            if (i >= inputBuffer.length()) continue;
            buffer.append(inputBuffer.charAt(i));
            begofline = inputBuffer.charAt(i) == '\n' || inputBuffer.charAt(i) == ';';
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Regexps load(String fileName, RefObject<String> errorMessage, RefObject<String> ilanguageName, RefObject<String> olanguageName) {
        ParameterCheck.mandatoryString("fileName", fileName);
        ParameterCheck.mandatory("errorMessage", errorMessage);
        ParameterCheck.mandatory("ilanguageName", ilanguageName);
        ParameterCheck.mandatory("olanguageName", olanguageName);
        errorMessage.argvalue = null;
        ilanguageName.argvalue = null;
        olanguageName.argvalue = null;
        Regexps regexps = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF8"));
            String header = bufferedReader.readLine();
            if (!(header.equals("# NooJ V1") || header.equals("# NooJ V2") || header.equals("# NooJ V3") || header.equals("# NooJ V4"))) {
                errorMessage.argvalue = "Header not compatible";
                Dic.writeLog((String)errorMessage.argvalue);
                Regexps regexps2 = null;
                return regexps2;
            }
            String rawBuffer = "";
            String line = bufferedReader.readLine();
            while (line != null) {
                rawBuffer = rawBuffer + line;
                rawBuffer = rawBuffer + "\n";
                line = bufferedReader.readLine();
            }
            RefObject<GramType> gramType = new RefObject<GramType>(GramType.FLX);
            String buf = Regexps.removeComments(rawBuffer, ilanguageName, olanguageName, gramType);
            Language ilanguage = new Language((String)ilanguageName.argvalue);
            regexps = new Regexps(null, GramType.FLX, null, null);
            int iBuffer = 0;
            while (iBuffer < buf.length()) {
                StringBuilder rulename = new StringBuilder();
                RefObject<Object> exp = new RefObject<Object>(null);
                int end = Regexps.getRule(buf, iBuffer, rulename, exp);
                if (end == -1) {
                    break;
                }
                if (end == -2) {
                    errorMessage.argvalue = "Cannot parse rule:" + buf.substring(iBuffer, iBuffer + 15);
                    Dic.writeLog((String)errorMessage.argvalue);
                    Regexps regexps3 = null;
                    return regexps3;
                }
                if (!regexps.grammar.grams.containsKey(rulename)) {
                    Regexp re = null;
                    re = new Regexp(ilanguage, (String)exp.argvalue, (GramType)((Object)gramType.argvalue));
                    regexps.grammar.grams.put(rulename.toString(), re.Grm);
                }
                iBuffer = end;
            }
        }
        catch (IOException e) {
            errorMessage.argvalue = e.getMessage();
            Dic.writeLog((String)errorMessage.argvalue);
            Regexps regexps4 = null;
            return regexps4;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    System.out.println("Error while closing " + fileName);
                }
            }
        }
        return regexps;
    }
}

